import os

import yaml

from . import commons
import si_tests.utils.templates as template_utils


def get_yaml_content(yaml_path,
                     file_not_found_fail=True):
    try:
        with open(yaml_path, "r") as f:
            data = yaml.safe_load(f)
        return data
    except FileNotFoundError:
        if file_not_found_fail:
            raise
        msg = "No such file or directory: {}".format(yaml_path)
        commons.LOG.error(msg)


def get_yaml_all_ontent(yaml_path,
                        file_not_found_fail=True):
    try:
        with open(yaml_path, "r") as f:
            documents = list(yaml.safe_load_all(f))
        return documents
    except FileNotFoundError:
        if file_not_found_fail:
            raise
        msg = "No such file or directory: {}".format(yaml_path)
        commons.LOG.error(msg)


def render_yaml_content(yaml_path, options=None):
    """Read YAML file as a Jinja2 template"""
    template = template_utils.render_template(yaml_path, options)
    data = yaml.safe_load(template)
    return data


def save_to_yaml(data, yaml_path, mode="w"):
    with open(yaml_path, mode) as f:
        yaml.dump(data, f)


def save_to_yaml_all(docs, yaml_path, mode="w"):
    with open(yaml_path, mode) as f:
        yaml.dump_all(docs, f)


def read_file(path):
    with open(path, "r") as f:
        data = f.read().strip()
    return data


def get_new_name(yaml_path):
    basename = os.path.basename(yaml_path)
    return join(commons.ARTIFACTS_DIR, basename)


def get_example(path):
    return join(commons.RELEASE_DIR, "examples", path)


def get_release(path):
    return join(commons.RELEASE_DIR, "release", path)


def get_context(path):
    return join(commons.CONTEXT_DIR, path)


def get_artifact(path):
    return join(commons.ARTIFACTS_DIR, path)


def join(base_path, *path):
    return os.path.abspath(os.path.join(base_path, *path))


def get_osdpl():
    return get_example("osdpl/{}.yaml".format(
        commons.CONTEXT_NAME))


def get_osdpl_content():
    return get_yaml_content(get_osdpl())


def get_ssl():
    certs_path = get_context("certs")
    ca_cert = read_file(join(certs_path, "ca.crt"))
    api_cert = read_file(join(certs_path, "api.pem"))
    api_key = read_file(join(certs_path, "api-key.pem"))
    return ca_cert, api_cert, api_key
