#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1MiracephSecret(base.BaseModel):
    pass


class V1MiracephSecretList(base.BaseModelList):
    pass


class MiracephSecret(base.K8sNamespacedResource):
    resource_type = 'miracephsecret'
    model = V1MiracephSecret


class MiracephSecretManager(base.K8sBaseManager):
    model = V1MiracephSecretList
    resource_class = MiracephSecret
    resource_group = 'lcm.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'miracephsecrets'
