#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1KaaSRack(base.BaseModel):
    pass


class V1KaaSRackList(base.BaseModelList):
    pass


class KaaSRack(base.K8sNamespacedResource):
    resource_type = 'rack'
    model = V1KaaSRack

    @property
    def cluster(self) -> str:
        return self.data['metadata']['labels']\
            .get('cluster.sigs.k8s.io/cluster-name')


class KaaSRackManager(base.K8sBaseManager):
    model = V1KaaSRackList
    resource_class = KaaSRack
    resource_group = 'ipam.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'racks'

    def filter(self, namespace, cluster_name=None):
        racks = self.list(namespace=namespace)
        if cluster_name:
            racks = [rack for rack in racks
                     if rack.cluster == cluster_name]
        return racks
