#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1KaaSMachine(base.BaseModel):
    pass


class V1KaaSMachineList(base.BaseModelList):
    pass


class KaaSMachine(base.K8sNamespacedResource):
    resource_type = 'machine'
    model = V1KaaSMachine

    @property
    def cluster(self) -> str:
        return self.data['metadata']['labels'].get('cluster.sigs.k8s.io/cluster-name')

    def machinepool(self) -> str:
        """Returns machinepool name which contains current machine or None if machine not in machinepool

        :return:
        """
        return self.data['metadata']['labels'].get('kaas.mirantis.com/machinepool-name', None)


class KaaSMachineManager(base.K8sBaseManager):
    model = V1KaaSMachineList
    resource_class = KaaSMachine
    resource_group = 'cluster.k8s.io'
    resource_version = 'v1alpha1'
    resource_plural = 'machines'

    def filter(self, namespace, mp_name=None, cluster_name=None):
        machines = self.list(namespace=namespace)
        if mp_name:
            machines = [machine for machine in machines
                        if machine.machinepool() == mp_name]
        if cluster_name:
            machines = [machine for machine in machines
                        if machine.cluster == cluster_name]
        return machines
