from si_tests.lcm.openstack_lcm import run_test, tempest


def test_run_tempest(os_manager):
    report_name = "tempest_report"
    run_pod = "openstack-tempest-run-tests"
    service = "tempest"
    try:
        run_test.run_tests(os_manager, report_name, run_pod, service,
                           tempest.get_run_command)

        log_name = "tempest.log"
        results_pod = "tempest-test-results-pod"
        volume_log_dir = "/var/lib/tempest/data/"
        run_test.save_report(
            os_manager, report_name, results_pod, volume_log_dir,
            log_name=log_name)

        run_test.convert_results_to_xml(report_name)
        run_test.archive_log(log_name)
    finally:
        run_test.turn_off_service(os_manager, service)
