from si_tests import settings
from si_tests import logger
from si_tests.utils import exceptions
from si_tests.utils import waiters

LOG = logger.logger


def _get_cluster_related_realm_roles(cluster_name, roles):
    return [x["name"] for x in roles if cluster_name in x["name"]]


def _check_scopes_deleted(kaas_manager, cluster_name, keycloak_admin_client):
    scopes = [x for x in kaas_manager.get_scopes()
              if cluster_name in x.name]
    cluster_related_roles = _get_cluster_related_realm_roles(
        cluster_name, keycloak_admin_client.get_realm_roles())
    return len(scopes) == len(cluster_related_roles) == 0


def test_detach_byo_ucp(kaas_manager, keycloak_admin_client):
    # detaching cluster
    cluster_name = settings.TARGET_CLUSTER
    ns = kaas_manager.get_namespace(settings.TARGET_NAMESPACE)
    ucp_cluster = ns.get_cluster(cluster_name)
    mgmt_k8s = kaas_manager.api
    parent_k8s = ucp_cluster.get_parent_cluster().k8sclient
    ucp_k8sclient = ucp_cluster.k8sclient

    scopes = [x for x in kaas_manager.get_scopes() if cluster_name in x.name]

    LOG.info("Scopes before detach: {}".format(scopes))

    cluster_related_roles = _get_cluster_related_realm_roles(
        cluster_name, keycloak_admin_client.get_realm_roles())
    LOG.info("Cluster related roles before detach: {}".format(
        cluster_related_roles))

    ucp_cluster.delete()

    LOG.info("Checking that cluster object is deleted")
    waiters.wait(
        lambda: len(mgmt_k8s.kaas_clusters.list(
            namespace=ns.name)) == 0, timeout=1800, interval=10)

    assert len(mgmt_k8s.kaas_machines.list(namespace=ns.name)) == 0, \
        "Not all machines were deleted " \
        "{}".format(mgmt_k8s.kaas_machines.list(namespace=ns.name))

    assert len(parent_k8s.kaas_helmbundles.list(namespace=ns.name)) == 0, \
        "Not all helmbundles were deleted " \
        "{}".format(parent_k8s.kaas_helmbundles.list(namespace=ns.name))

    assert len(parent_k8s.kaas_lcmclusters.list(namespace=ns.name)) == 0, \
        "Not all lcmclusters were deleted " \
        "{}".format(parent_k8s.kaas_lcmclusters.list(namespace=ns.name))

    assert len(parent_k8s.kaas_lcmmachines.list(namespace=ns.name)) == 0, \
        "Not all lcmmachines were deleted " \
        "{}".format(parent_k8s.kaas_lcmmachines.list(namespace=ns.name))

    LOG.info("Make sure metrics-server pod is removed from standalone UCP")
    waiters.wait(
        lambda: len(ucp_k8sclient.pods.list(
            namespace='kube-system',
            name_prefix='metrics-server')) == 0,
        timeout=140, interval=10)

    LOG.info("Make sure helm-controller pods are removed from standalone UCP")
    waiters.wait(
        lambda: len(ucp_k8sclient.pods.list(
            namespace='kube-system',
            name_prefix='helm-controller')) == 0,
        timeout=140, interval=10)

    ns.delete()
    ns.wait_for_deletion()

    LOG.info("Make sure namespace is deleted")
    waiters.wait(
        lambda: not mgmt_k8s.namespaces.present(name=ns.name),
        timeout=100, interval=10)

    LOG.info("Check keycloak scopes after delete cluster and namespace")
    try:
        waiters.wait(
            lambda: _check_scopes_deleted(
                kaas_manager, cluster_name, keycloak_admin_client),
            timeout=300, interval=10)
    except exceptions.TimeoutError:
        scopes = [x for x in kaas_manager.get_scopes() if cluster_name in x.name]
        LOG.info("Scopes after detach: {}".format(scopes))
        assert len(scopes) == 0,\
            "Not all scopes have been deleted: {}".format(scopes)

        cluster_related_roles = _get_cluster_related_realm_roles(
            cluster_name, keycloak_admin_client.get_realm_roles())
        LOG.info(f"Cluster related roles after detach: {cluster_related_roles}")
        assert len(cluster_related_roles) == 0, \
            f"Not all roles have been deleted: {scopes}"

    LOG.info("Checking that byocredentials object is deleted")
    waiters.wait(
        lambda: len(mgmt_k8s.kaas_byocredentials.list(
            namespace=ns.name)) == 0, timeout=100, interval=10)
