import random
import string

from si_tests import logger
from si_tests.lcm.openstack_lcm.policies import Policy
from si_tests.utils.utils import verify


LOG = logger.logger


def test_crud_operations_designate_policy(openstack_client_manager,
                                          policy_user):
    """Test CRUD operations  for designate policy
       https://mirantis.testrail.com/index.php?/cases/view/4963574

       Parameters required for test execution:
         - KUBECONFIG

       Setup environment:
       Create user with role member
    """
    user_name, password = policy_user
    http_exception = "forbidden"
    os_service = 'designate'
    os_pod = 'designate-central'
    policy = Policy(os_service, os_pod)
    letters = string.ascii_lowercase
    name_postfix = ''.join(random.choice(letters) for i in range(5))

    def _delete_resources():
        zone_list = openstack_client_manager.zone_blacklist.list([])
        for zone_bl in zone_list:
            if name_postfix in zone_bl.get('pattern'):
                openstack_client_manager.zone_blacklist.delete(
                    [zone_bl.get('id')])

    try:
        get_policy_file_before_update = \
            ['/bin/sh', '-c',
             r' grep -rin "create_blacklist:\|find_blacklists:"'
             ' /etc/designate/policy.d/02-custom.yaml']
        policy.check_policy_absent_before_update(
            get_policy_file_before_update)

        LOG.info("Step 1: Check that policy is absent. "
                 "Creating and listing of zone's blacklist is allowed only to admin user")
        step = 1

        zone_blacklist = openstack_client_manager.zone_blacklist.create([
            "--pattern", f"zone_blacklist_no_policy_admin_{name_postfix}"])
        verify(zone_blacklist,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Create zone blacklist is possible by admin")
        zone_bl_list = openstack_client_manager.zone_blacklist.list([])
        verify(zone_bl_list,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List zone blacklist is possible by admin")
        error_output = openstack_client_manager.zone_blacklist.create([
            "--pattern", f"zone_blacklist_no_policy_user_{name_postfix}",
            f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Create zone blacklist isn't possible by user")
        error_output = openstack_client_manager.zone_blacklist.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List zone blacklist isn't possible by user")

        LOG.info("Step 2: Add to osdpl new rule")
        step = 2
        policy_add_role = {'create_blacklist': '@', 'find_blacklists': '@'}

        policy.update_policy_osdpl(policy_add_role, step)

        LOG.info("Step 3: Check on designate central pod policies was added")
        check_policy_file = ['/bin/sh', '-c',
                             ' cat /etc/designate/policy.d/02-custom.yaml']
        policy.wait_policy_updated_on_pod(check_policy_file, policy_add_role,
                                          step)

        LOG.info("Step 4: Check that policy added and zone blacklist "
                 "is shown by member and admin user")
        step = 4

        zone_blacklist = openstack_client_manager.zone_blacklist.create([
            "--pattern", f"zone_blacklist_policy_added_admin_{name_postfix}"])
        verify(zone_blacklist,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Create zone blacklist is possible by admin")
        zone_bl_list = openstack_client_manager.zone_blacklist.list([])
        verify(zone_bl_list,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List zone blacklist is possible by admin")
        zone_blacklist = openstack_client_manager.zone_blacklist.create([
            "--pattern", f"zone_blacklist_policy_added_user_{name_postfix}",
            f"--os-username={user_name}", f"--os-password={password}"])
        verify(zone_blacklist,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Create zone blacklist is possible by user")
        zone_bl_list = openstack_client_manager.zone_blacklist.list(
            [f"--os-username={user_name}", f"--os-password={password}"])
        verify(zone_bl_list,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List zone blacklist is possible by user")

        LOG.info("Step 5: Update policies. Check that policy added "
                 "on designate central pod ")
        step = 5
        policy_update_role = {'create_blacklist': '!',
                              'find_blacklists': '!'}
        policy.update_policy_osdpl(policy_update_role, step)
        policy.wait_policy_updated_on_pod(check_policy_file,
                                          policy_update_role, step)

        LOG.info("Step 6: Check that policy was updated and zone "
                 "blacklist can not be created by admin and user")
        step = 6

        error_output = openstack_client_manager.zone_blacklist.create([
            "--pattern",
            f"zone_blacklist_policy_updated_admin_{name_postfix}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Incorrect result."
               f" Actual result: {error_output['stderr']}, "
               f"expected result: {http_exception}",
               f"[Step {step}]: Policy is updated. "
               "Create zone blacklist is not possible by admin")
        error_output = openstack_client_manager.zone_blacklist.list(
            [],
            combined_output=True
        )
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List zone blacklist is not possible by admin")
        error_output = openstack_client_manager.zone_blacklist.create([
            "--pattern", f"zone_blacklist_policy_updated_user_{name_postfix}",
            f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Incorrect result."
               f" Actual result: {error_output['stderr']}, "
               f"expected result: {http_exception}",
               f"[Step {step}]: Policy is updated. "
               "Create zone blacklist is not possible by user")
        error_output = openstack_client_manager.zone_blacklist.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List zone blacklist is not possible by user")

    finally:
        LOG.info("Step 7: Delete Policy. Check that policy was deleted and"
                 " result the same in first step ")
        step = 7
        policy_not_role = None
        policy.update_policy_osdpl(policy_not_role, step)

        policy.wait_policy_updated_on_pod(check_policy_file, {},
                                          step)
        zone_blacklist = openstack_client_manager.zone_blacklist.create([
            "--pattern",
            f"zone_blacklist_policy_deleted_admin_{name_postfix}"])
        verify(zone_blacklist,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Create zone blacklist is possible by admin")
        zone_bl_list = openstack_client_manager.zone_blacklist.list([])
        verify(zone_bl_list,
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List zone blacklist is possible by admin")

        error_output = openstack_client_manager.zone_blacklist.create([
            "--pattern", "zone_blacklist_policy_deleted_user",
            f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Incorrect result."
               f" Actual result: {error_output['stderr']}, "
               f"expected result: {http_exception}",
               f"[Step {step}]: Policy is updated. "
               "Create zone blacklist is not possible by user")
        error_output = openstack_client_manager.zone_blacklist.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "List zone blacklist is not possible by user")

        LOG.info("Delete created resources")

        _delete_resources()
