import yaml
import pytest

from si_tests.managers import openstack_manager
from si_tests.deployments import openstack_deploy
from si_tests.deployments.utils import commons
from si_tests.runners import parallel_runner
from si_tests import settings
from si_tests.managers.kaas_manager import Manager
from si_tests.utils import utils


@pytest.mark.usefixtures('introspect_no_PRODX_51933_after_lcm')
def test_deploy_openstack_env():
    timeouts = settings.OPENSTACK_DEPLOY_TIMEOUT
    step = [openstack_deploy.deploy_helmbundle_controller]
    parallel_runner.assert_step(step, 1, timeouts.get("1", 300))

    step = [openstack_deploy.deploy_dns,
            openstack_deploy.generate_ssl_certificates]

    parallel_runner.assert_step(step, 1, timeouts.get("1", 300))

    step = [openstack_deploy.deploy_openstack_cluster]

    if openstack_deploy.is_tf_deployment():
        step.append(openstack_deploy.deploy_tungsten_fabric)

    if settings.OPENSTACK_DEPLOY_VAULT:
        step.append(openstack_deploy.deploy_vault)
    # time has been increased from 2400 to 3000 in debugging purposes
    # then it could be reduced again.
    parallel_runner.assert_step(step, 2, timeouts.get("2", 8000))

    step = []
    if not settings.OPENSTACK_DEPLOY_FAKE_DEPLOYMENT:
        step.append(openstack_deploy.configure_dns)
    parallel_runner.assert_step(step, 3, timeouts.get("3", 1800))

    # Workaround for PRODX-11384
    if settings.OPENSTACK_DEPLOY_DPDK and \
            settings.OPENSTACK_DPDK_AVAILABILITY_ZONE_NAME == "nova":
        set_flavor_property()

    # Check cluster readiness
    if settings.CHECK_READINESS:
        check_readiness()


@utils.log_method_time()
def check_readiness():
    commons.LOG.info("Check cluster readiness")
    kaas_manager = Manager(kubeconfig=settings.KUBECONFIG_MGMT_PATH)
    ns = kaas_manager.get_namespace(settings.TARGET_NAMESPACE)
    cluster = ns.get_cluster(settings.TARGET_CLUSTER)
    cluster.check.check_cluster_readiness()


@utils.log_method_time()
def set_flavor_property():
    os_manager = openstack_manager.OpenStackManager(
        kubeconfig=settings.KUBECONFIG_PATH)
    keystone_client_pod = [
        pod for pod in os_manager.get_os_pods() if
        'keystone-client' in pod.name]
    assert len(keystone_client_pod) > 0, (
        "No pods found with keystone-client name prefix")
    keystone_client_pod = keystone_client_pod[0]
    flavors_cmd = [
        '/bin/sh', '-c',
        'PYTHONWARNINGS=ignore::UserWarning openstack flavor list --all --long -f json']
    flavors = yaml.safe_load(
        keystone_client_pod.exec(flavors_cmd))
    hugepages_sz = '2048'
    flavor_property = 'hw:mem_page_size={}'.format(
        hugepages_sz)
    for flavor in flavors:
        f_id = flavor.get('ID')
        f_name = flavor.get('Name')
        f_properties = flavor.get('Properties')
        if 'hw:mem_page_size' not in f_properties:
            property_cmd = [
                '/bin/sh', '-c',
                'PYTHONWARNINGS=ignore::UserWarning openstack flavor set {} '
                '--property {}'.format(f_id, flavor_property)]
            keystone_client_pod.exec(property_cmd)
            commons.LOG.info(
                "Flavor {} updated with property {}".format(
                    f_name, flavor_property))
        else:
            commons.LOG.info(
                "Flavor {} was not updated. "
                "hw:mem_page_size propertie is already "
                "existed in flavor properites: {}".format(
                    f_name, f_properties))
