#!/usr/bin/env bash

echo 'set_power'

declare -A nodes_pw
nodes_pw=(\
[cz8045]='2wV6jRY5yaMTSfjB' \
[cz8046]='2wV6jRY5yaMTSfjB' \
[cz8047]='2wV6jRY5yaMTSfjB' \
[cz7939]='2wV6jRY5yaMTSfjB' \
[cz7940]='2wV6jRY5yaMTSfjB' \
[cz7941]='2wV6jRY5yaMTSfjB' \
[cz7942]='2wV6jRY5yaMTSfjB' \
[cz7944]='2wV6jRY5yaMTSfjB' \
[cz7914]='2wV6jRY5yaMTSfjB'
)

function set_power(){
  local action=${1:-'status'}
  local nset=${2:-'all'}
  declare -A nodes=();
  declare -A nodes_child=();
  declare -A nodes_mgmt=();

  nodes_child=([cz7939]='5.43.227.40' [cz7940]='5.43.227.41' \
               [cz7941]='5.43.227.42' [cz7942]='5.43.227.43' \
	       [cz7944]='5.43.227.45' [cz7914]='5.43.227.24')

  nodes_mgmt=([cz8045]='5.43.227.88' [cz8046]='5.43.227.90' \
              [cz8047]='5.43.227.89')
  # awesome merge event...
  case "$nset" in
      'mgmt')
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
      'child')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
      ;;
      'all')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
  esac

  for i in "${!nodes[@]}"; do
    echo "node: $i"
    set -x
    ipmitool -I lanplus -H ${nodes[$i]} -U engineer -P "${nodes_pw[$i]}" chassis power $action || true
    set +x
  done
 }

