#!/usr/bin/env bash

echo 'set_power'

function _KILL_JOBS() {
  for pid in $(jobs -r -p); do
    if [[ $(ps -p $pid) && $? -eq 0 ]]; then
      kill $pid
    fi
  done
}

function _INT_TERM() {
  echo ""
  echo ["EXIT"]

  _KILL_JOBS

  exit 1;
}

trap _INT_TERM INT TERM
trap _KILL_JOBS EXIT


function set_power(){
  local ACTION=${1:-'chassis power status'}
  local TARGET=${2:-'all'}

  local DEFAULT_LOGIN="engineer"

  # name ipmi_ip ipmi_port ipmi_login ipmi_password
  # vbmc- VMs on vsphere, see  PRODX-42807
  local MGMT=(
    "mgmt1-cz10149" "5.43.229.157" "623" ${DEFAULT_LOGIN} "PM3dqFFwe3fe"
    "mgmt2-cz7892" "5.43.225.238" "623" ${DEFAULT_LOGIN} "UTywpOU3eNIUTFYw"
    "mgmt3-cz7191" "185.8.58.204" "623" ${DEFAULT_LOGIN} "JMonisUTFiwOIJwe"
    "vbmc-master1" "172.16.38.123" "7231" "admin" "password"
    "vbmc-master2" "172.16.38.123" "7232" "admin" "password"
    "vbmc-master3" "172.16.38.123" "7233" "admin" "password"
  )

  local CHILD=(
    "cz10147" "5.43.229.155" "623" ${DEFAULT_LOGIN} "PM3dqFFwe3fe"
    "cz10148" "5.43.229.156" "623" ${DEFAULT_LOGIN} "PM3dqFFwe3fe"
    "cz10150" "5.43.229.158" "623" ${DEFAULT_LOGIN} "PM3dqFFwe3fe"
    "cz10151" "5.43.229.159" "623" ${DEFAULT_LOGIN} "PM3dqFFwe3fe"
    "cz7788" "5.43.225.124" "623" ${DEFAULT_LOGIN} "PM3dqFFwe3fe"
    "cz808" "176.74.219.187" "623" ${DEFAULT_LOGIN} "cWuaU8gRXVKA"
    "cz809" "176.74.219.189" "623" ${DEFAULT_LOGIN} "cWuaU8gRXVKA"
    "cz810" "176.74.219.190" "623" ${DEFAULT_LOGIN} "cWuaU8gRXVKA"
    "cz811" "176.74.219.207" "623" ${DEFAULT_LOGIN} "cWuaU8gRXVKA"
  )

  case $TARGET in
    mgmt) ARR=( ${MGMT[@]} );
      ;;
    child) ARR=( ${CHILD[@]} );
      ;;
    all) ARR=( ${MGMT[@]} ${CHILD[@]} );
      ;;
  esac

  for i in $(seq 0 5 $(expr ${#ARR[@]} - 1)); do
    echo "node: ${ARR[i]}"
    CMD=(ipmitool -I lanplus -H ${ARR[i+1]} -p ${ARR[i+2]} -U ${ARR[i+3]} -P ${ARR[i+4]} $ACTION)
    echo ${CMD[@]}| sed "s/${ARR[i+4]}/*****/"

    ${CMD[@]}
  done
}

#main
if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
    set_power "$@"
fi
