#!/usr/bin/env bash

#set -x
echo 'set_power'

#phys-1481	KaaS Management cluster
# KVM-host - cz7894
# [cz7894]='kcz!GTR2vzj7bgz7tqw' '5.43.225.240'
#	Managed cluster - control plane
# cz8175
# cz8176
# cz7640
#	Managed cluster - worker/storage
# cz7895
# cz7814

function _KILL_JOBS() {
  for pid in $(jobs -r -p); do
    if [[ $(ps -p $pid) && $? -eq 0 ]]; then
      kill $pid
    fi
  done
}

function _INT_TERM() {
  echo ""
  echo ["EXIT"]

  _KILL_JOBS

  # exit 1;
}

trap _INT_TERM INT TERM
trap _KILL_JOBS EXIT


function set_power(){
  local ACTION=${1:-'chassis power status'}
  local TARGET=${2:-'all'}

  local VBMC_DEFAULT_IPMI="172.18.184.6"
  local VBMC_DEFAULT_LOGIN="admin"
  local VBMC_DEFAULT_PASSWORD="r00tme"

  CHILD=(
     'child-worker-1' $VBMC_DEFAULT_IPMI '6331' $VBMC_DEFAULT_LOGIN $VBMC_DEFAULT_PASSWORD
     'child-worker-2' $VBMC_DEFAULT_IPMI '6332' $VBMC_DEFAULT_LOGIN $VBMC_DEFAULT_PASSWORD
     'child-worker-3' $VBMC_DEFAULT_IPMI '6333' $VBMC_DEFAULT_LOGIN $VBMC_DEFAULT_PASSWORD
     'cz7640' '185.8.59.245' 623 engineer 'JyC2Kc5GVLWQ'
     'cz7814' '176.74.217.230' 623 engineer 'kcz!GTR2vzj7bgz7tqw'
     'cz7895' '5.43.225.241' 623 engineer 'kcz!GTR2vzj7bgz7tqw'
     'cz8175' '5.43.225.150' 623 engineer 'kcz!GTR2vzj7bgz7tqw'
     'cz8176' '5.43.225.151' 623 engineer 'kcz!GTR2vzj7bgz7tqw'
  )

  # name ipmi_ip ipmi_port ipmi_login ipmi_password
  local MGMT=(
    'mgmt-0' $VBMC_DEFAULT_IPMI '6231' $VBMC_DEFAULT_LOGIN $VBMC_DEFAULT_PASSWORD
    'mgmt-1' $VBMC_DEFAULT_IPMI '6232' $VBMC_DEFAULT_LOGIN $VBMC_DEFAULT_PASSWORD
    'mgmt-2' $VBMC_DEFAULT_IPMI '6233' $VBMC_DEFAULT_LOGIN $VBMC_DEFAULT_PASSWORD
  )
  # awesome merge event...
  case "$nset" in
      'mgmt')
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
      'child')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
      ;;
      'all')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
  esac


  case $TARGET in
    mgmt) ARR=( ${MGMT[@]} );
      ;;
    child) ARR=( ${CHILD[@]} );
      ;;
    all) ARR=( ${MGMT[@]} ${CHILD[@]} );
      ;;
  esac

  for i in $(seq 0 5 $(expr ${#ARR[@]} - 1)); do
    echo "node: ${ARR[i]}"
    CMD=(ipmitool -I lanplus -H ${ARR[i+1]} -p ${ARR[i+2]} -U ${ARR[i+3]} -P ${ARR[i+4]} $ACTION)
    echo ${CMD[@]}

    ${CMD[@]}
  done
}

#main
if [[ "${BASH_SOURCE[0]}" == "${0}" ]]; then
    set_power "$@"
fi

