from si_tests.deployments.utils import wait_utils, commons, kubectl_utils, file_utils
from si_tests.deployments.utils.namespace import NAMESPACE


def deploy_local_volume_provisioner(os_manager, timeout):
    kubectl = kubectl_utils.Kubectl()
    commons.LOG.info("Deploy LVP")
    kubectl.apply(file_utils.get_release("40-local-volume-provisioner.yaml"))

    commons.LOG.info("Add LVP RBAC")
    rbac = """apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  labels:
  name: osh-system-local-storage-admin:cluster-admin
roleRef:
  apiGroup: rbac.authorization.k8s.io
  kind: ClusterRole
  name: cluster-admin
subjects:
- kind: ServiceAccount
  name: local-storage-admin
  namespace: osh-system"""

    kubectl.apply(stdin=rbac)

    wait = wait_utils.Waiter(os_manager, timeout, NAMESPACE.osh)
    commons.LOG.info("Wait till LVP starts")
    wait.daemonset("local-volume-provisioner")

    commons.LOG.info("LVP successfully deployed")
