import os

from si_tests.deployments.utils import (wait_utils, commons, kubectl_utils,
                                        file_utils)
from si_tests.deployments.utils.namespace import NAMESPACE


def deploy_ceph_controller(os_manager, timeout):
    rbac = """apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  labels:
  name: rook-ceph-rook-ceph-system:cluster-admin
roleRef:
  apiGroup: rbac.authorization.k8s.io
  kind: ClusterRole
  name: cluster-admin
subjects:
- kind: ServiceAccount
  name: rook-ceph-system
  namespace: rook-ceph
---
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  labels:
  name: ceph-lcm-mirantis-ceph-operator-account:cluster-admin
roleRef:
  apiGroup: rbac.authorization.k8s.io
  kind: ClusterRole
  name: cluster-admin
subjects:
- kind: ServiceAccount
  name: ceph-operator-account
  namespace: ceph-lcm-mirantis"""

    kubectl = kubectl_utils.Kubectl()
    commons.LOG.info("Add ceph RBAC")
    kubectl.apply(stdin=rbac)

    ceph_yaml = file_utils.get_release("50-ceph-controller.yaml")
    if not os.path.exists(ceph_yaml):
        ceph_yaml = file_utils.get_release("32-ceph-controller.yaml")

    commons.LOG.info("Deploy ceph controller")
    kubectl.apply(ceph_yaml)

    wait = wait_utils.Waiter(os_manager, timeout, NAMESPACE.rook)
    commons.LOG.info("Wait till ceph-controller starts")
    wait.deployment("ceph-controller", namespace=NAMESPACE.ceph)

    commons.LOG.info("Wait till rook operator starts")
    wait.deployment("rook-ceph-operator")

    # commons.LOG.info("Wait till rook discover starts")
    # wait.daemonset("rook-discover")

    commons.LOG.info("Ceph controller successfully deployed")
