#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1TFTool(base.BaseModel):
    pass


class V1TFToolList(base.BaseModelList):
    pass


class TFTool(base.K8sNamespacedResource):
    resource_type = 'tftool'
    model = V1TFTool


class TFToolManager(base.K8sBaseManager):
    model = V1TFToolList
    resource_class = TFTool
    resource_group = 'tool.tf.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'tftools'


class V2TFTool(base.BaseModel):
    pass


class V2TFToolList(base.BaseModelList):
    pass


class TFToolV2(base.K8sNamespacedResource):
    resource_type = 'tftool'
    model = V2TFTool


class TFToolManagerV2(base.K8sBaseManager):
    model = V2TFToolList
    resource_class = TFToolV2
    resource_group = 'tf.mirantis.com'
    resource_version = 'v2'
    resource_plural = 'tftools'
