#    Copyright 2021 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations


from si_tests.clients.k8s import base


class V1KaaSOpenstackDeploymentStatus(base.BaseModel):
    pass


class V1OpenstackDeploymentStatusList(base.BaseModelList):
    pass


class OpenstackDeploymentStatus(base.K8sNamespacedResource):
    resource_type = 'openstackdeploymentstatus'
    model = V1KaaSOpenstackDeploymentStatus


class OpenStackDeploymentStatusManager(base.K8sBaseManager):
    model = V1OpenstackDeploymentStatusList
    resource_class = OpenstackDeploymentStatus
    resource_group = 'lcm.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'openstackdeploymentstatus'
