#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base
from si_tests import logger

LOG = logger.logger


class V1KaaSLcmMachine(base.BaseModel):
    pass


class V1KaaSLcmMachineList(base.BaseModelList):
    pass


class KaaSLcmMachine(base.K8sNamespacedResource):
    resource_type = 'lcmmachine'
    model = V1KaaSLcmMachine


class KaaSLcmMachineManager(base.K8sBaseManager):
    model = V1KaaSLcmMachineList
    resource_class = KaaSLcmMachine
    resource_group = 'lcm.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'lcmmachines'

    def _list_all(self, states=None, **kwargs):
        response = self.api.list_cluster_custom_object(
            group=self.resource_group,
            version=self.resource_version,
            plural=self.resource_plural,
            **kwargs)
        if states:
            for lcmmachine in response['items'][:]:
                if 'status' in lcmmachine:
                    lcmm_s = lcmmachine['status']
                    lcmm_state = \
                        None if not lcmm_s else lcmm_s.get('state', None)
                    if lcmm_state not in states:
                        response['items'].remove(lcmmachine)
                else:
                    name = lcmmachine['metadata']['name']
                    ns = lcmmachine['metadata']['namespace']
                    LOG.warning(f"LCMmachine {name} in {ns} "
                                f"namespace has no status")
                    response['items'].remove(lcmmachine)
        return self._deserialize_custom_object_list(
            response, V1KaaSLcmMachineList, V1KaaSLcmMachine)

    def present(self, name, namespace):
        """Check that specified lcmmachine name exists in the namespace"""
        return any([lcmmachine.name for lcmmachine in self.list(namespace=namespace)
                    if lcmmachine.name == name])
