#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base
from si_tests import logger
import si_tests.utils.waiters as helpers

LOG = logger.logger


class V1KaaSBootstrapRegion(base.BaseModel):
    pass


class V1KaaSBootstrapRegionList(base.BaseModelList):
    pass


class KaaSBootstrapRegion(base.K8sNamespacedResource):
    resource_type = 'bootstrapregion'
    model = V1KaaSBootstrapRegion

    def _delete(self, async_del=False, timeout=300, body=None, **kwargs):
        LOG.info(f"Removing bootstrapregion {self.namespace}/{self.name}")
        if not body:
            body = {}
        self._manager.api.delete_namespaced_custom_object(
            group=self._manager.resource_group,
            version=self._manager.resource_version,
            namespace=self.namespace,
            plural=self._manager.resource_plural,
            name=self.name,
            body=body,
            **kwargs)
        if not async_del:
            helpers.wait(lambda: not self._manager.present(self.name, self.namespace),
                         timeout=timeout,
                         timeout_msg=f"Timeout waiting for bootstrapregion deletion {self.namespace}/{self.name}")
        LOG.info(f"Bootstrapregion {self.namespace}/{self.name} has been deleted.")

    @property
    def provider(self):
        return self.read().spec['provider']


class KaaSBootstrapRegionManager(base.K8sBaseManager):
    model = V1KaaSBootstrapRegionList
    resource_class = KaaSBootstrapRegion
    resource_group = 'kaas.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'bootstrapregions'
