#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base


class V1CertificateRequest(base.BaseModel):
    pass


class V1CertificateRequestList(base.BaseModelList):
    pass


class CertificateRequest(base.K8sNamespacedResource):
    resource_type = 'certificaterequest'
    model = V1CertificateRequest


class CertificateRequestManager(base.K8sBaseManager):
    model = V1CertificateRequestList
    resource_class = CertificateRequest
    resource_group = 'cert-manager.io'
    resource_version = 'v1'
    resource_plural = 'certificaterequests'
