# si-tests

Contribute
----------

Please send patches using https://gerrit.mcp.mirantis.com:

```
git remote add gerrit ssh://<username>@gerrit.mcp.mirantis.com:29418/kaas/si-tests
git review
```

Clone the repo
--------------
```
git clone https://gerrit.mcp.mirantis.com/kaas/si-tests
cd ./si-tests
```

Install requirements
--------------------
```
pip install -r ./si_tests/requirements.txt
```

Run bootstrap
---------------
Required variables:
```
    # ENV_NAME used to create a seed node and KaaS management cluster
    export ENV_NAME=test-01
    # Variables used to access seed node
    export SEED_SSH_PRIV_KEY_FILE=~/.ssh/id_rsa_system_key_8133
    export CLOUD_KEY_NAME=system_key_8133

    # Variables used to render clouds.yaml
    export OS_USERNAME=...
    export OS_PASSWORD=...
```
Optional variables:
```
    # Variables used to render clouds.yaml
    export OS_AUTH_URL=
    export OS_IDENTITY_API_VERSION=
    export OS_INTERFACE=
    export OS_PROJECT_ID=
    export OS_PROJECT_NAME=
    export OS_REGION_NAME=
    export OS_USER_DOMAIN_NAME=

    # Use an alternative clouds.yaml
    export CLOUDS_YAML_PATH=$(pwd)/clouds.yaml

    # Variables used to render KaaS bootstrap templates
    export KAAS_EXTERNAL_NETWORK_ID=bf6b85a1-39db-4582-b0d1-f4291dddb9cf
    export KAAS_MANAGEMENT_CLUSTER_DNS1=172.18.224.4
    export KAAS_MANAGEMENT_CLUSTER_FLAVOR=kaas.small
    export KAAS_MANAGEMENT_CLUSTER_IMAGE=bionic-server-cloudimg-amd64-20190612
    export KAAS_MANAGEMENT_CLUSTER_K8S_VERSION=1.13.5
    export KAAS_MANAGEMENT_CLUSTER_SLAVE_NODES=1
```
Run bootstrap test:
```
pytest si_tests/tests/deployment/management-cluster/test_provision_mgm_cluster.py
```

Run KaaS UI test suite
------------------------------------------
```
    export KUBECONFIG=<kubeconfig_path>

pytest si_tests/tests/deployment/management-cluster/test_kaas_ui.py
```

Run IAM bdd test suite
------------------------------------------
```
    export KUBECONFIG=<kubeconfig_path>

pytest si_tests/tests/deployment/management-cluster/test_iam_bdd.py
```

Run k8s e2e conformance tests
------------------------------------------
```
# specify mgmt cluster kubeconfig as usual
    export KUBECONFIG=<kubeconfig_path>

# if you need to test child cluster, please specify also
    export TARGET_CLUSTER=<child_cluster_name>
    export TARGET_NAMESPACE=<child_cluster_namespace>

pytest si_tests/tests/deployment/test_k8s_conformance.py
```

Run LMA tests
------------------------------------------
```
# specify mgmt cluster kubeconfig as usual
    export KUBECONFIG=<kubeconfig_path>

# if you need to test child cluster, please specify also
    export TARGET_CLUSTER=<child_cluster_name>
    export TARGET_NAMESPACE=<child_cluster_namespace>

pytest si_tests/tests/deployment/test_sl_test.py
```
