#    Author: Alex Savatieiev (osavatieiev@mirantis.com; a.savex@gmail.com)
#    Copyright 2019-2022 Mirantis, Inc.
import glob
import os

from setuptools import find_packages, setup

here = os.path.abspath(os.path.dirname(__file__))
README = open(os.path.join(here, 'README.md')).read()

DATA = [
    ('etc', [f for f in glob.glob(os.path.join('etc', '*'))]),
    ('templates', [f for f in glob.glob(os.path.join('templates', '*'))]),
    ('scripts', [f for f in glob.glob(os.path.join('scripts', '*'))]),
    ('versions', [f for f in glob.glob(os.path.join('versions', '*'))])
]

dependencies = [
    'six',
    'pyyaml',
    'jinja2',
    'requests',
    'ipaddress',
    'configparser',
    'kubernetes',
    'gevent',
    'falcon'
]

entry_points = {
    "console_scripts": [
        "mos-checker = cfg_checker.cfg_check:config_check_entrypoint",
        "chk-pkg = cfg_checker.cli.packages:entrypoint",
        "chk-net = cfg_checker.cli.network:entrypoint",
        "chk-reclass = cfg_checker.cli.reclass:entrypoint",
        "checker-agent = cfg_checker.agent.cfg_agent:entrypoint"
    ]
}


setup(
    name="mcp-checker",
    version="0.7",
    author="Alex Savatieiev",
    author_email="osavatieiev@mirantis.com",
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 3.6"
    ],
    keywords="QA, openstack, kubernetes, salt, config, "
             "reclass, networking, ceph",
    entry_points=entry_points,
    url="",
    packages=find_packages(),
    include_package_data=True,
    package_data={
        '': ['*.conf', '*.env', '*.list', '*.html']
    },
    zip_safe=False,
    install_requires=dependencies,
    data_files=DATA,
    license="Apache Licence, version 2",
    description="MCP/MCC/MOS Checker tool. "
                "For use only on Mirantis product deployments",
    long_description=README
)
