#    Author: Alex Savatieiev (osavatieiev@mirantis.com; a.savex@gmail.com)
#    Copyright 2019-2022 Mirantis, Inc.
import os

from cfg_checker.common.settings import pkg_dir

_env_name = "local"
_config_path = os.path.join(pkg_dir, 'etc', _env_name + '.env')


def add_global_arguments(parser):
    parser.add_argument(
        "-d",
        "--debug",
        action="store_true", default=False,
        help="Set CLI logging level to DEBUG"
    )
    parser.add_argument(
        "-k",
        "--insecure",
        action="store_true", default=False,
        help="Use insecure way in SSL requests"
    )
    parser.add_argument(
        '-s',
        '--sudo',
        action='store_true', default=True,
        help="Use sudo for getting salt creds"
    )
    parser.add_argument(
        '--ssh-direct',
        action='store_true', default=False,
        help="Force SSH to do direct connection instead of port forwarding"
    )

    parser.add_argument(
        '--force-no-key',
        action='store_true', default=False,
        help="Force SSH to login with no key"
    )
    parser.add_argument(
        '--skip-nodes',
        metavar='skip_string', default=None,
        help="String with nodes to skip. Only trailing '*' supported!"
             " Example: 'cmp*,ctl01'"
    )
    parser.add_argument(
        '--kube-config',
        metavar='kube_config', default="/root/.kube/config",
        help="Kube config path with certificates and keys. "
             "Default: '/root/.kube/config'"
    )
    parser.add_argument(
        '--force-env-type',
        metavar='force_env_type',
        help="Specify env to use if function supports multiple among detected"
             " Example: SALT/KUBE"
    )
    parser.add_argument(
        '--env-name',
        metavar='env_name', default=_env_name,
        help="Use of given env name instead of MCP_ENV var"
             "Default: {}".format(_env_name)
    )

    parser.add_argument(
        '--env-config',
        metavar='env_config', default=_config_path,
        help="Force use of given env file"
             "Default: '{}'".format(_config_path)
    )

    parser.add_argument(
        '--skip-nodes-file',
        metavar='skip_nodes_file', default=None,
        help="Filename with nodes to skip. Note: use fqdn node names."
    )

    parser.add_argument(
        '--force-node-network',
        metavar='force_node_network', default=None,
        help="When creating node shell, use this network instead if internal"
             "IP. Format: '10.10.10.'"
    )
