#    Author: Alex Savatieiev (osavatieiev@mirantis.com; a.savex@gmail.com)
#    Copyright 2019-2022 Mirantis, Inc.
class CheckerBaseExceptions(Exception):
    pass


class CheckerException(CheckerBaseExceptions):
    def __init__(self, message, *args, **kwargs):
        super(CheckerException, self).__init__(message, *args, **kwargs)
        # get the trace
        # TODO: get and log traceback

        # prettify message
        self.message = "# CheckerException: {}".format(message)


class ConfigException(CheckerException):
    def __init__(self, message, *args, **kwargs):
        super(ConfigException, self).__init__(message, *args, **kwargs)
        self.message = "# Configuration error: {}".format(message)


class CommandNotSupportedException(CheckerException):
    def __init__(self, message, *args, **kwargs):
        super(CommandNotSupportedException, self).__init__(
            message,
            *args,
            **kwargs
        )
        self.message = "# Command not supported: {}".format(message)


class CommandTypeNotSupportedException(CheckerException):
    def __init__(self, message, *args, **kwargs):
        super(CommandTypeNotSupportedException, self).__init__(
            message,
            *args,
            **kwargs
        )
        self.message = "# Command type not supported: {}".format(message)


class SaltException(CheckerException):
    def __init__(self, message, *args, **kwargs):
        super(SaltException, self).__init__(message, *args, **kwargs)
        self.message = "# Salt error: {}".format(message)


class KubeException(CheckerException):
    def __init__(self, message, *args, **kwargs):
        super(KubeException, self).__init__(message, *args, **kwargs)
        self.message = "# Kube client error: {}".format(message)


class InvalidReturnException(CheckerException):
    def __init__(self, message, *args, **kwargs):
        super(InvalidReturnException, self).__init__(message, *args, **kwargs)
        self.message = "# Unexpected return value: {}".format(message)


class TimeoutException(CheckerException):
    def __init__(self, message, *args, **kwargs):
        super(TimeoutException, self).__init__(message, *args, **kwargs)
        self.message = "# Timed out waiting: {}".format(message)


class ErrorMappingException(CheckerException):
    def __init__(self, message, *args, **kwargs):
        super(ErrorMappingException, self).__init__(message, *args, **kwargs)
        self.message = "# Unexpected error mapping/type: {}".format(message)
