#    Author: Alex Savatieiev (osavatieiev@mirantis.com; a.savex@gmail.com)
#    Copyright 2019-2022 Mirantis, Inc.
"""Constants that is not to be changed and used in all other files
"""

from __future__ import absolute_import, print_function

import itertools

_cnt = itertools.count()
NODE_DOWN = next(_cnt)
NODE_UP = next(_cnt)
NODE_SKIP = next(_cnt)

# version const order is important!
# biggest get shown in report top row
VERSION_NA = next(_cnt)
VERSION_OK = next(_cnt)
VERSION_UP = next(_cnt)
VERSION_DOWN = next(_cnt)
VERSION_WARN = next(_cnt)
VERSION_ERR = next(_cnt)

# action const order is important!
# biggest get shown in report top row
ACT_NA = next(_cnt)
ACT_UPGRADE = next(_cnt)
ACT_NEED_UP = next(_cnt)
ACT_NEED_DOWN = next(_cnt)
ACT_REPO = next(_cnt)

del _cnt

all_actions = {
    ACT_UPGRADE: "upgrade possible",
    ACT_NEED_UP: "needs upgrade",
    ACT_NEED_DOWN: "needs downgrade",
    ACT_REPO: "repo update",
    ACT_NA: ""
}

all_pkg_statuses = {
    VERSION_OK: "ok",
    VERSION_UP: "upgraded",
    VERSION_DOWN: "downgraded",
    VERSION_WARN: "warning",
    VERSION_ERR: "error",
    VERSION_NA: "nostatus"
}

node_status = {
    NODE_UP: "up",
    NODE_DOWN: "down",
    NODE_SKIP: "skip"
}

uknown_code = "unk"

ENV_TYPE_GLOB = "MCP"
ENV_TYPE_SALT = "SALT"
ENV_TYPE_KUBE = "KUBE"
ENV_TYPE_LINUX = "LINUX"
ENV_LOCAL = "local"

supported_envs = [ENV_TYPE_LINUX, ENV_TYPE_SALT, ENV_TYPE_KUBE]

all_salt_roles_map = {
    "apt": "repository",
    "bmk": "validation",
    "cfg": "master",
    "cid": "cicd",
    "cmn": "storage_monitor",
    "cmp": "compute",
    "ctl": "openstack_controller",
    "dbs": "database",
    "gtw": "openstack_gateway",
    "kvm": "foundation",
    "log": "stacklight_logger",
    "mon": "monitoring",
    "msg": "messaging",
    "mtr": "stacklight_metering",
    "ntw": "contrail_networking",
    "nal": "contrail_analytics",
    "osd": "storage_node",
    "prx": "proxy",
    "rgw": "storage_rados",
    "unk": "uknown"
}

ubuntu_releases = ["trusty", "xenial", "ubuntu", "bionic", "focal", "jammy", "noble"]
kaas_ubuntu_active = [
    "ubuntu-1.1.0",
    "ubuntu-1.0.0",
    "ubuntu-0.0.9",
    "ubuntu-0.0.8",
    "ubuntu-2025-09-18-004153",
    "ubuntu-2025-10-13-003937",
    "ubuntu-2025-11-10-003925"
]
mcp_active_tags = [
    "2019.2.0",
    "2019.2.25",
    "2019.2.26"
]
all_arch = ["amd64"]
repo_types = {
    "main": "Officially supported software",
    "restricted": "Supported software that is not "
                  "available under a completely free license",
    "universe": "Community maintained software, "
                "i.e. not officially supported software",
    "multiverse": "Software that is not free",
    "contrib": "Free software, but is dependent to non-free software",
    "uknown": "No specific description available"
}

_repos_info_archive = "repo.info.tgz"
_repos_versions_archive = "repo.versions.tgz"
_pkg_desc_archive = "pkg.descriptions.tgz"

_repos_index_filename = "repoindex.json"
_mainteiners_index_filename = "mainteiners.json"
_mirantis_versions_filename = "mirantis_v.json"
_other_versions_filename = "other_v.json"

all_kube_roles_map = {
    'node-role.kubernetes.io/master': "k8s-master",
    'openstack-compute-node': "os-cmp",
    'openstack-control-plane': "os-ctl",
    'openstack-gateway': "os-gtw",
    'openvswitch': "ovs",
    'local-volume-provisioner': "",
    'ceph_role_mgr': "ceph-mgr",
    'ceph_role_mon': "ceph-mon",
    'com.docker.ucp.collection.shared': "ucp-shared",
    'com.docker.ucp.collection.system': "ucp-system",
    'com.docker.ucp.collection.swarm': "ucp-swarm",
    'com.docker.ucp.collection.root': "ucp-root",
}

truth = ['true', '1', 't', 'y', 'yes', 'yeah', 'yup', 'certainly', 'uh-huh']

ubuntu_versions = {
    "24.10": "Noble Numbat",
    "24.04": "Ornate Ocelot",
    "22.04": "Jammy Jellyfish",
    "20.10": "Groovy Gorilla",
    "20.04": "Focal Fossa",
    "18.04": "Bionic Beaver",
    "16.04": "Xenial Xerus",
    "14.04": "Trusty Tahr",
}

nova_openstack_versions = {
    "32": "Flamingo",
    "31": "Epoxy",
    "30": "Dalmatian",
    "29": "Caracal",
    "28": "Bobcat",
    "27": "Antelope",
    "26": "Zed",
    "25": "Yoga",
    "24": "Xena",
    "23": "wallaby",
    "22": "victoria",
    "21": "ussuri",
    "20": "train",
    "19": "stein",
    "18": "rocky",
    "17": "queens",
    "00": "not installed"
}
