#    Author: Alex Savatieiev (osavatieiev@mirantis.com; a.savex@gmail.com)
#    Copyright 2019-2022 Mirantis, Inc.
from cfg_checker.common import logger
from cfg_checker.common.salt_utils import SaltRemote
from cfg_checker.common.kube_utils import KubeRemote


# instance of the salt client
salt = None
kube = None


def get_salt_remote(config):
    """Singleton-like creation of instance

    Arguments:
        config {base_config} -- an instance to base_config
            with creds and params

    Returns:
        SaltRemote -- instance of salt client
    """

    global salt
    logger.info("Creating salt remote instance")
    # create it once
    if salt is None:
        salt = SaltRemote(config)
    # return once required
    return salt


def get_kube_remote(config):
    """Singleton-like creation of instance

    Arguments:
        config {base_config} -- an instance to base_config
            with creds and params

    Returns:
        KubeRemote -- instance of kube client
    """
    global kube
    logger.info("Creating kube remote client instance")
    # Create it once
    if kube is None:
        kube = KubeRemote(config)
    return kube
