import contextlib

import pytest

from si_tests import feature_flags
from si_tests import settings
from si_tests.utils import templates


def raises():
    return pytest.raises(feature_flags.UnknownFlagException)


@contextlib.contextmanager
def succeeds():
    yield


condition_tmpl = """\
{% if feature_flags.enabled("a") -%}
enabled
{%- else -%}
disabled
{%- endif %}
"""


@pytest.mark.parametrize("flags,known_flags,template,expected,cond", [
    ([], [], "simple", "simple", succeeds()),
    ([], [], condition_tmpl, "", raises()),
    ([], ["a"], condition_tmpl, "disabled", succeeds()),
    ([], ["a"], condition_tmpl, "disabled", succeeds()),
    (["a"], ["a"], condition_tmpl, "enabled", succeeds()),
])
def test_render_template(
        tmpdir, monkeypatch,
        flags, known_flags, template, expected, cond):
    monkeypatch.setattr(
        settings, "FEATURE_FLAGS",
        feature_flags.FeatureFlags(flags, known_flags),
    )
    tmpl = tmpdir.join("template.j2")
    tmpl.write(template)
    with cond:
        result = templates.render_template(tmpl)
        assert expected == result
