import contextlib

import pytest

from si_tests import feature_flags


def raises():
    return pytest.raises(feature_flags.UnknownFlagException)


@contextlib.contextmanager
def succeeds():
    yield


@pytest.mark.parametrize("flag,known_flags,cond", [
    ("a", ["a"], succeeds()),
    ("a", [], raises()),
    ("a", ["b"], raises()),
])
def test_assert_known(flag, known_flags, cond):
    with cond:
        feature_flags.assert_known(flag, known_flags)


@pytest.mark.parametrize("s,known_flags,expected_flags,cond", [
    ("", ["a"], [], succeeds()),
    ("a", ["a"], ["a"], succeeds()),
    ("a,b", ["a", "b"], ["a", "b"], succeeds()),
    ("a", ["a", "b"], ["a"], succeeds()),
    ("a", [], [], raises()),
    ("a,b", ["a"], [], raises()),
    ("a", ["b"], [], raises()),
])
def test_parse(s, known_flags, expected_flags, cond):
    with cond:
        ff = feature_flags.parse(s, known_flags)
        assert ff.known_flags == known_flags
        assert ff.flags == expected_flags


@pytest.mark.parametrize("flag,flags,known_flags,cond,expected", [
    ("a", ["a"], ["a"], succeeds(), True),
    ("b", ["a"], ["a", "b"], succeeds(), False),
    ("b", ["a"], ["a"], raises(), False),
])
def test_enabled(flag, flags, known_flags, cond, expected):
    ff = feature_flags.FeatureFlags(flags, known_flags)
    with cond:
        assert expected == ff.enabled(flag)
