from si_tests.lcm.openstack_lcm import run_test, stepler
from si_tests import settings
from si_tests import logger

LOG = logger.logger


def test_run_stepler(os_manager):

    report_name = "stepler_report"
    run_pod = "openstack-stepler-run-tests"
    service = "stepler"
    extra_conf_options = settings.STEPLER_EXTRA_CONFIG_OPTIONS

    try:
        run_test.run_tests(os_manager, report_name, run_pod, service, stepler.get_run_command, extra_conf_options)

        log_name = "test.log"
        results_pod = "stepler-test-results-pod"
        volume_log_dir = "/opt/stepler/test_reports/"
        run_test.save_report(os_manager, report_name, results_pod, volume_log_dir, log_name=log_name, service=service)

        run_test.convert_results_to_xml(report_name)
        run_test.archive_log(log_name)
    finally:
        LOG.info(f"Turn off {service}")
        run_test.turn_off_service(os_manager, service)
