#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
import pytest
from si_tests import logger

LOG = logger.logger


@pytest.mark.usefixtures('ovn_migration_checker')
@pytest.mark.usefixtures('mos_workload_downtime_report')
@pytest.mark.usefixtures('mos_loadtest_os_refapp')  # Should be used if ALLOW_WORKLOAD == True
@pytest.mark.usefixtures('mos_per_node_workload_check_after_test')
def test_ovn_migration_basic(os_manager, ovn_migration_manager, show_step):
    """Verifies migration procedure
    Parameters required for the test execution:
        - KUBECONFIG
    Scenario:
        1. Run migration preflight checks
        2. Create database backups
        3. Run migration
        4. Check deployment status is applied
        5. Check deployment health status is ready
    """
    show_step(1)
    # preflight checks themselves will be covered by separate tests
    ovn_migration_manager.pre_flight_checks(fail_on_check=False)
    show_step(2)
    ovn_migration_manager.backup()
    show_step(3)
    ovn_migration_manager.migrate()
    # Check statuses
    show_step(4)
    LOG.info("Wait osdpl status=Ready")
    os_manager.wait_os_deployment_status(timeout=1800)
    show_step(5)
    LOG.info("Wait osdplst all services health status=Ready")
    os_manager.wait_openstackdeployment_health_status(timeout=1800)
