import pytest
import re
from si_tests import settings
from si_tests import logger
from si_tests.utils import waiters
import yaml


LOG = logger.logger


@pytest.mark.usefixtures('log_method_time')
def test_ironic_db_stateless(kaas_manager, ironic_client, show_step):
    """Add bm compute node.

    Scenario:
        1. Get nodes from ironic
        2. Scale ironic to 0 and wait readiness
        3. Check ironic pods after downscale
        4. Scale back ironic and wait readiness
        5. Get nodes from ironic
        6. Diff nodes in ironic
    """

    ns = kaas_manager.get_namespace(settings.TARGET_NAMESPACE)
    cluster = ns.get_cluster(settings.TARGET_CLUSTER)
    show_step(1)

    def get_bm_node_uuids():
        ironic_api_pod = [p.name for p in cluster.k8sclient.pods.list(namespace='kaas') if
                          'ironic' in p.name and 'operator' not in p.name][0]
        pod = cluster.k8sclient.pods.get(name=ironic_api_pod, namespace='kaas')
        exec_ = pod.exec(['/bin/sh', '-c', 'curl -ksS https://localhost:6385/v1/nodes'],
                         container='ironic-api')
        exec_ = exec_[exec_.find('{'):]
        LOG.debug(f"Ironic nodes json: {exec_}")
        data = yaml.safe_load(exec_)
        LOG.info(f"BM nodes: {data}")
        bm_inst_uuids = [node['instance_uuid'] for node in data['nodes']]
        LOG.info(f"Nodes UUID: {bm_inst_uuids}")
        return [uuid for uuid in bm_inst_uuids if uuid and uuid != 'None']

    bm_inst_uuids_before = get_bm_node_uuids()
    ironic_deployment = cluster.k8sclient.deployments.get(
        name="ironic",
        namespace="kaas")
    ironic_replicas = ironic_deployment.data['spec']['replicas']
    LOG.info(f"ironic_replicas: {ironic_replicas}")
    show_step(2)
    ironic_deployment.patch(
        body={"spec": {"replicas": 0}})
    LOG.info('Wait for ironic scale down')
    ironic_deployment.wait_ready(timeout=600, interval=10)
    show_step(3)

    def ironic_pods():
        get_pods = [pod for pod in cluster.k8sclient.pods.list(namespace='kaas')
                    if re.match('ironic-.{10}-.{5}', pod.name)]
        LOG.info(f"Ironic pods: {get_pods}")
        return get_pods

    waiters.wait(
        lambda: ironic_pods() == [],
        timeout=300, interval=10,
        timeout_msg='Ironic pods still present')
    show_step(4)
    ironic_deployment.patch(
        body={"spec": {"replicas": ironic_replicas}})
    LOG.info("Wait deployment ready status")
    ironic_deployment.wait_ready(timeout=600, interval=10)
    show_step(5)

    waiters.wait(
        lambda: len(bm_inst_uuids_before) == len(get_bm_node_uuids()),
        timeout=600, interval=60,
        timeout_msg='Wait for ironic nodes recovery')
    bm_inst_uuids_after = get_bm_node_uuids()
    show_step(6)
    assert sorted(bm_inst_uuids_before) == sorted(bm_inst_uuids_after),\
        "Ironic node UUID's was changed"
    ns.wait_baremetalhosts_statuses(wait_status='provisioned',
                                    retries=30,
                                    interval=90)
