from si_tests import settings
from si_tests import logger
from si_tests.utils import waiters


LOG = logger.logger


def test_add_fake_key_value_osdpl(os_manager):
    """Add fake Key: Value to osdpl.
       Parameters required for test execution:
         - KUBECONFIG
    """

    osdpl_name = settings.OSH_DEPLOYMENT_NAME

    LOG.info("Check that all fingerprints in actual state before updating osdpl")
    os_manager.wait_openstack_helmbundles_fingerprint(osdpl_name)
    LOG.info("All fingerprints in actual state before upgrade")

    osdpl = os_manager.get_openstackdeployment(osdpl_name)

    # Save Secrets before update
    LOG.info("Get secrets before updating osdpl")
    secrets_before_update = os_manager.get_os_secrets(True)

    # Save daemonsets before update
    LOG.info("Get daemonsets before updating osdpl")
    daemonsets_before_update = os_manager.get_os_daemonsets(True)

    # Save Statefulsets before update
    LOG.info("Get statefulsets before updating osdpl")
    statefulsets_before_update = os_manager.get_os_statefulsets(True)

    # Save ConfigMaps before update
    LOG.info("Get configmaps before updating osdpl")
    configmaps_before_update = os_manager.get_os_configmaps(True)

    # Save Deployments before update
    LOG.info("Get deployments before updating osdpl")
    deployments_before_update = os_manager.get_os_deployments(True)

    # Save OpenStack deployment before add key:value
    osdpl_before_update = osdpl.read()
    fp_before_update = osdpl_before_update.status['fingerprint']

    # Prepare and apply adding key:value
    common = {
        'spec': {
            'common': {
                'openstack':
                    {'values': {'fake_key_os': 'fake_value_os'}},
                'infra':
                    {'values': {'fake_key_infra': 'fake_value_infra'}}
            }
        }
    }

    LOG.info("Patching osdpl with %s", common)
    osdpl.patch(common)

    LOG.info("Wait fp of osdpl updated.")
    timeout_msg = ("OpenStack deployment doesn't reached"
                   " status `deployed=True`")
    waiters.wait(os_manager.check_osdpl_status_value,
                 predicate_args=('fingerprint',
                                 fp_before_update,
                                 False),
                 timeout=1200,
                 timeout_msg=timeout_msg)

    LOG.info("Check all helmbundles fingerprints equals fp of osdpl")
    os_manager.wait_openstack_helmbundles_fingerprint(osdpl_name)

    LOG.info("Wait until all osdpl children statuses success=True")
    os_manager.wait_all_osdpl_children_status()

    LOG.info("Check generation was not updated for deamonsets")
    daemonsets_after_update = os_manager.get_os_daemonsets(True)
    os_manager.check_resource_generation_bumped(
        daemonsets_before_update,
        daemonsets_after_update,
        False)

    LOG.info("Check generation was not updated for statefulsets")
    statefulsets_after_update = os_manager.get_os_statefulsets(True)
    os_manager.check_resource_generation_bumped(
        statefulsets_before_update,
        statefulsets_after_update,
        False)

    LOG.info("Check generation was not updated for deployments")
    deployments_after_update = os_manager.get_os_deployments(True)
    os_manager.check_resource_generation_bumped(
        deployments_before_update,
        deployments_after_update,
        False)

    LOG.info("Check resource version was not updated for secrets")
    secrets_after_update = os_manager.get_os_secrets(True)
    os_manager.check_resource_version_updated(
        secrets_before_update,
        secrets_after_update,
        False,
        settings.SKIP_SECRET_LIST)

    LOG.info("Check resource version was not updated for configmaps")
    configmaps_after_update = os_manager.get_os_configmaps(True)

    os_manager.check_resource_version_updated(
        configmaps_before_update,
        configmaps_after_update,
        False,
        settings.SKIP_CONFIGMAP_LIST)
