# This file contains HA tests for Openstack cluster components
# These tests panned to run on virtual envs in periodic jobs

import pytest
from si_tests import settings
from si_tests import logger


LOG = logger.logger


@pytest.mark.usefixtures("mos_workload_downtime_report")
@pytest.mark.usefixtures("mos_per_node_workload_check_after_test")
def test_graceful_mosk_pod_restarts(os_manager):
    """Test gracefully restart pods in namespace to check if MOS components
    are resistant to reboot
    """
    for ns in [
        os_manager.openstack_namespace,
        os_manager.os_helm_system_namespace,
        os_manager.redis_namespace,
    ]:
        LOG.info(f"Restart pods in {ns} namespace.")
        for res_type in ["deployments", "statefulsets", "daemonsets"]:
            for obj in os_manager.get_resources(res_type, ns):
                obj.restart()
        os_manager.wait_resources(ns, timeout=settings.OPENSTACK_DEPLOY_TIMEOUT["1"])
