from si_tests.deployments import openstack_deploy
from si_tests.runners import parallel_runner
from si_tests import settings


def test_deploy_openstack_env():
    timeouts = settings.OPENSTACK_DEPLOY_TIMEOUT

    step = [openstack_deploy.deploy_helmbundle_controller]

    parallel_runner.assert_step(step, 1, timeouts.get("1", 1200))

    step = [openstack_deploy.deploy_metallb,
            openstack_deploy.deploy_dns,
            openstack_deploy.generate_ssl_certificates]

    parallel_runner.assert_step(step, 2, timeouts.get("1", 1200))

    step = [openstack_deploy.deploy_openstack_cluster]

    parallel_runner.assert_step(step, 3, timeouts.get("2", 4200))

    step = []
    if not settings.OPENSTACK_DEPLOY_FAKE_DEPLOYMENT:
        step.append(openstack_deploy.configure_dns)

    parallel_runner.assert_step(step, 4, timeouts.get("5", 1800))
