from si_tests.deployments import openstack_deploy
from si_tests.runners import parallel_runner
from si_tests import settings


def test_deploy_openstack_env():
    timeouts = settings.OPENSTACK_DEPLOY_TIMEOUT

    step = [openstack_deploy.deploy_helmbundle_controller]

    parallel_runner.assert_step(step, 1, timeouts.get("1", 300))

    step = [openstack_deploy.deploy_local_volume_provisioner,
            openstack_deploy.deploy_metallb,
            openstack_deploy.deploy_ceph_controller,
            openstack_deploy.deploy_openstack_controller,
            openstack_deploy.deploy_redis]

    parallel_runner.assert_step(step, 2, timeouts.get("2", 1800))

    step = [openstack_deploy.deploy_dns,
            openstack_deploy.generate_ssl_certificates]

    parallel_runner.assert_step(step, 3, timeouts.get("3", 300))

    step = [openstack_deploy.deploy_ceph_cluster,
            openstack_deploy.deploy_openstack_cluster]

    if settings.OPENSTACK_DEPLOY_VAULT:
        step.append(openstack_deploy.deploy_vault)

    if settings.OPENSTACK_DEPLOY_IAM:
        step.append(openstack_deploy.deploy_iam)

    if openstack_deploy.is_tf_deployment():
        step.append(openstack_deploy.deploy_tungsten_fabric)

    parallel_runner.assert_step(step, 4, timeouts.get("4", 2400))

    step = []
    if not settings.OPENSTACK_DEPLOY_FAKE_DEPLOYMENT:
        step.append(openstack_deploy.configure_dns)

    if settings.OPENSTACK_DEPLOY_STACKLIGHT:
        step.append(openstack_deploy.deploy_stacklight)

    parallel_runner.assert_step(step, 5, timeouts.get("5", 1800))

    if openstack_deploy.is_baremetal():
        parallel_runner.assert_step(
            [openstack_deploy.deploy_vbmc], 6, timeouts.get("6", 800))
