import yaml

from os import environ
from si_tests import settings
from si_tests import logger
import si_tests.utils.templates as templates_utils
from si_tests.utils import utils


LOG = logger.logger


def test_openstack_controller_functional(os_manager):
    """Run functional openstack controller tests"""
    pod = None
    net_policy = None
    is_rockoon_used = utils.is_rockoon_used(os_manager.api)
    oc_name = "openstack-controller"
    oc_name_underscore = "openstack_controller"
    if is_rockoon_used:
        oc_name = "rockoon"
        oc_name_underscore = "rockoon"
    np_template_options = {"application_label": oc_name, "component_label": "exporter"}

    try:
        oc_tests_image = environ.get('OPENSTACK_CONTROLLER_TESTS_IMAGE')
        if not oc_tests_image:
            # Select the OS controller test image with the same version as the OS controller
            os_controller = os_manager.get_os_operator_deployment()
            os_controller_image = os_controller.read().spec.template.spec.containers[0].image
            parts = os_controller_image.split("/")
            if is_rockoon_used:
                parts[-1] = parts[-1].replace("rockoon", "rockoon-tests", 1)
            else:
                parts[-1] = parts[-1].replace("openstack-controller", "openstack-controller-tests", 1) + "-tests"
            oc_tests_image = "/".join(parts)
        LOG.info(f"Using openstack controller test image: {oc_tests_image}")
        options = {"oc_tests_image": oc_tests_image, "oc_name": oc_name,
                   "oc_name_underscore": oc_name_underscore}

        templates = templates_utils.render_template(settings.OPENSTACK_CONTROLLER_TESTS_POD_TEMPLATE, options)
        LOG.debug(templates)
        pod_body = yaml.load(templates, Loader=yaml.SafeLoader)
        net_policies = os_manager.api.networkpolicies.list(
            namespace=os_manager.os_helm_system_namespace)
        # Temporary allow access to exporter pod, as we allow access only from stacklight NS
        if net_policies:
            np_body = yaml.load(templates_utils.render_template(settings.OPENSTACK_CONTROLLER_TESTS_NETWORK_POLICY,
                                                                options=np_template_options),
                                Loader=yaml.SafeLoader)
            net_policy = os_manager.api.networkpolicies.create(
               name=f"{oc_name}-tests-exporter",
               namespace=os_manager.os_helm_system_namespace,
               body=np_body)

        pod = os_manager.api.pods.create(
            name=settings.OPENSTACK_CONTROLLER_TESTS_POD_NAME,
            namespace=settings.OPENSTACK_CONTROLLER_TESTS_POD_NAMESPACE,
            body=pod_body)
        pod.wait_phase('Running')
        pod.wait_test(filepath='./test_*', timeout=settings.OPENSTACK_CONTROLLER_TESTS_TIMEOUT)
        pod.cp_from_pod(source_dir="/var/lib/tests/", compression="-z")

        os_manager.wait_os_deployment_status(timeout=900, status="APPLIED")
        os_manager.wait_osdpl_services()

        LOG.info("Wait until all services in health section"
                 " get status `Ready`")
        os_manager.wait_openstackdeployment_health_status()

        LOG.info("Check that OpenStack pods are active.")
        os_manager.wait_os_resources(timeout=settings.OPENSTACK_LCM_OPERATIONS_TIMEOUT, interval=20)
    finally:
        if pod is not None:
            pod.delete()
        if net_policy is not None:
            net_policy.delete()
