#    Copyright 2019 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
from si_tests import settings
from si_tests import logger

LOG = logger.logger


def test_keystone_iam_integration_cli(kaas_manager, keycloak_ip, show_step):
    """Bootstrap KaaS on OpenStack VMs
    Scenario:
        1. Erase previous KaaS environment and seed node, if exists
        2. Create a seed VM using heat template
        3. Prepare seed node to run KaaS bootstrap
        4. Check bootstrap templates for management cluster
        5. Bootstrap KaaS seed and managed clusters
        6. Check versions
        7. Wait for all pods to be Running and Ready
        8. Check that all expected pods exists
        9. Download bootstrap artifacts
        10. Check LDAP integration if enabled
        11. Erase created KaaS environment
    """

    ns = kaas_manager.get_namespace(namespace=settings.TARGET_NAMESPACE)
    cluster = ns.get_cluster(settings.TARGET_CLUSTER)
    kubectl_client = cluster.k8sclient
    pods = kubectl_client.pods.list_starts_with(
        "keystone-client-", namespace="openstack")
    assert len(pods) > 0, "POD <keystone-client-*> not found"
    keystone_pod = pods[0]
    writer_password = kaas_manager.si_config.get_keycloak_user_password('writer')
    envs = (f"OS_CLIENT_SECRET=someRandomClientSecretMightBeNull "
            f"OS_DISCOVERY_ENDPOINT=https://{keycloak_ip}/ "
            f"OS_PROJECT_DOMAIN_ID=default "
            f"OS_INTERFACE=public "
            f"OS_USERNAME=writer "
            f"OS_PASSWORD={writer_password} "
            f"OS_CACERT=/etc/ssl/certs/openstack-ca-bundle.pem "
            f"OS_AUTH_URL=http://keystone-api.openstack.svc.cluster.local:5000/v3 "
            f"OS_CLIENT_ID=os "
            f"OS_PROTOCOL=mapped "
            f"OS_IDENTITY_PROVIDER=keycloak "
            f"OS_DISCOVERY_ENDPOINT=https://{keycloak_ip}/"
            f"auth/realms/iam/.well-known/openid-configuration "
            f"OS_AUTH_TYPE=v3oidcpassword "
            f"OS_PROJECT_NAME=admin "
            f"OS_CLOUD=")

    error_msg = "===ERROR==="
    LOG.info("\n" + keystone_pod.exec(["/bin/bash", "-c",
                                       f"{envs} env|grep OS_"]))

    server_list = keystone_pod.exec(["/bin/bash", "-c",
                                     f"{envs} "
                                     f"openstack -vvv --insecure server list "
                                     f"|| echo '{error_msg}'"])
    if error_msg in server_list:
        raise Exception(f"\n{server_list.replace(error_msg, '')}")
