terraform {
  required_version = ">= 0.14.0"
  required_providers {
    openstack = {
      source  = "terraform-provider-openstack/openstack"
      version = ">= 1.51.1"
    }
  }
}

provider "openstack" {
  use_octavia = "true"
  region      = var.region
}

resource "random_string" "password" {
  length  = 16
  special = false
}

resource "tls_private_key" "ssh_key" {
  algorithm = "RSA"
  rsa_bits  = "4096"
}

resource "local_file" "ssh_public_key" {
  content  = tls_private_key.ssh_key.private_key_pem
  filename = "./ssh_keys/${var.cluster_name}.pem"
  provisioner "local-exec" {
    command = "chmod 0600 ${local_file.ssh_public_key.filename}"
  }
}

resource "openstack_compute_keypair_v2" "key-pair" {
  name       = "${var.cluster_name}-key"
  public_key = tls_private_key.ssh_key.public_key_openssh
}

module "network" {
  source              = "./modules/network"
  cluster_name        = var.cluster_name
  external_network_id = var.external_network_id
  dns_ips             = var.dns_ip_list
}

module "masters" {
  source                = "./modules/masters"
  master_count          = var.master_count
  cluster_name          = var.cluster_name
  ssh_key               = openstack_compute_keypair_v2.key-pair.name
  master_image_name     = var.master_image_name
  master_flavor         = var.master_flavor
  external_network_name = var.external_network_name
  internal_network_name = module.network.network_name
  internal_subnet_id    = module.network.subnet_id
  base_sec_group_id     = module.network.base_security_group_id
}

module "workers" {
  source                = "./modules/workers"
  worker_count          = var.worker_count
  cluster_name          = var.cluster_name
  ssh_key               = openstack_compute_keypair_v2.key-pair.name
  worker_image_name     = var.worker_image_name
  worker_flavor         = var.worker_flavor
  external_network_name = var.external_network_name
  internal_network_name = module.network.network_name
  internal_subnet_id    = module.network.subnet_id
  base_sec_group_id     = module.network.base_security_group_id
}
