#!/usr/bin/env bash

echo 'set_power'

declare -A nodes_pw
nodes_pw=(\
[cz8065]='LIjncww2D23fw' \
[cz8066]='LIjncww2D23fw' \
[cz8067]='LIjncww2D23fw' \
[cz5272]='LIjncww2D23fw' \
[cz7857]='LIjncww2D23fw' \
[cz7787]='LIjncww2D23fw' \
[cz7987]='LIjncww2D23fw' \
[cz7842]='LIjncww2D23fw' \
[cz8062]='LIjncww2D23fw' \
[cz8063]='LIjncww2D23fw' \
[cz8064]='LIjncww2D23fw' \
)

function set_power(){
  local action=${1:-'status'}
  local nset=${2:-'all'}
  declare -A nodes=();
  declare -A nodes_child=();
  declare -A nodes_mgmt=();

  nodes_child=([cz8065]='5.43.227.110' \
               [cz8066]='5.43.227.111' [cz8067]='5.43.227.112' \
               [cz5272]='5.43.225.182' [cz7857]='5.43.225.199' \
               [cz7787]='5.43.225.123' [cz7987]='5.43.225.181' \
               [cz7842]='5.43.225.201')

   nodes_mgmt=([cz8062]='5.43.227.106' [cz8063]='5.43.227.107' \
               [cz8064]='5.43.227.108' )

  # awesome merge event...
  case "$nset" in
      'mgmt')
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
      'child')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
      ;;
      'all')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
  esac

  for i in "${!nodes[@]}"; do
    echo "node: $i"
    set -x
    ipmitool -I lanplus -H ${nodes[$i]} -U engineer -P "${nodes_pw[$i]}" chassis power $action
    set +x
  done
 }

