#!/usr/bin/env bash

echo 'set_power'

declare -A nodes_pw
nodes_pw=(\
[cz8058]='LNfYU#jeT34HBe' \
[cz8055]='LNfYU#jeT34HBe' \
[cz8133]='LNfYU#jeT34HBe' \
[cz8037]='LNfYU#jeT34HBe' \
[cz7910]='LNfYU#jeT34HBe' \
[cz7807]='LNfYU#jeT34HBe' \
[cz5725]='LNfYU#jeT34HBe' \
[cz8070]='LNfYU#jeT34HBe' \
[cz8081]='LNfYU#jeT34HBe' \
[cz5272]='LNfYU#jeT34HBe'
)

function set_power(){
  local action=${1:-'status'}
  local nset=${2:-'all'}
  declare -A nodes=();
  declare -A nodes_child=();
  declare -A nodes_mgmt=();

  nodes_child=([cz8058]='5.43.227.101' [cz8055]='5.43.227.98' \
               [cz8133]='5.43.227.158' [cz8037]='5.43.227.80' \
	       [cz7910]='5.43.227.20' [cz7807]='5.43.225.140' \
               [cz5725]='5.43.225.9')

  nodes_mgmt=([cz8070]='5.43.227.62' [cz8081]='5.43.227.159' \
              [cz5272]='5.43.225.182')
  # awesome merge event...
  case "$nset" in
      'mgmt')
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
      'child')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
      ;;
      'all')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
  esac

  for i in "${!nodes[@]}"; do
    echo "node: $i"
    set -x
    ipmitool -I lanplus -H ${nodes[$i]} -U engineer -P "${nodes_pw[$i]}" chassis power $action || true
    set +x
  done
 }

