#!/usr/bin/env bash

echo 'set_power'

declare -A nodes_pw
nodes_pw=(\
[cz7841]='a4oDmcyERtZsxMz' \
[cz7660]='a4oDmcyERtZsxMz' \
[cz7661]='a4oDmcyERtZsxMz' \
[cz7599]='a4oDmcyERtZsxMz' \
[cz8092]='a4oDmcyERtZsxMz' \
[cz7346]='a4oDmcyERtZsxMz' \
[cz7347]='a4oDmcyERtZsxMz' \
[cz7341]='a4oDmcyERtZsxMz' \
[cz7342]='a4oDmcyERtZsxMz' \
)

function set_power(){
  local action=${1:-'status'}
  local nset=${2:-'all'}
  declare -A nodes=();
  declare -A nodes_child=();
  declare -A nodes_mgmt=();

  nodes_child=([cz7599]='5.43.225.93' \
               [cz8092]='5.43.225.204' [cz7346]='185.8.59.18' \
               [cz7347]='185.8.59.19' [cz7341]='185.8.59.161' \
               [cz7342]='185.8.59.162')

   nodes_mgmt=([cz7841]='5.43.225.207' [cz7660]='5.43.225.202' \
               [cz7661]='5.43.229.24' )

  # awesome merge event...
  case "$nset" in
      'mgmt')
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
      'child')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
      ;;
      'all')
        for i in ${!nodes_child[@]}; do
            nodes[$i]="${nodes_child[$i]}"
        done
        for i in ${!nodes_mgmt[@]}; do
            nodes[$i]="${nodes_mgmt[$i]}"
        done
      ;;
  esac

  for i in "${!nodes[@]}"; do
    echo "node: $i"
    set -x
    ipmitool -I lanplus -H ${nodes[$i]} -U engineer -P "${nodes_pw[$i]}" chassis power $action
    set +x
  done
 }
