#!/usr/bin/env python3

from ansible.plugins.action import ActionBase

import json


class ActionModule(ActionBase):
    def __init__(self, *args, **kwargs):
        self._tmp = None
        self._task_vars = None
        super(ActionModule, self).__init__(*args, **kwargs)

    def _get_network_devices(self, dev_type=None):
        module_args = {
            'argv': ['ip', '--json', 'link', 'show']
        }
        if dev_type:
            module_args['argv'].extend(['type', dev_type])

        result = self._execute_module(module_name='command',
                                      module_args=module_args,
                                      task_vars=self._task_vars,
                                      tmp=self._tmp)
        return json.loads(result.get('stdout', '[]'))

    def run(self, tmp=None, task_vars=None):
        self._supports_check_mode = False
        self._supports_async = False
        self._tmp = tmp
        self._task_vars = task_vars

        result = super(ActionModule, self).run(tmp, task_vars)
        devices = self._get_network_devices(self._task.args.get('type'))
        result['by_name'] = {x['ifname']: x for x in devices if x}
        result['by_index'] = {x['ifindex']: x for x in devices if x}

        return result
