#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import os
import pytest
import yaml

from si_tests import logger
from si_tests import settings
from si_tests.managers.netchecker_manager import NetcheckerManager
from si_tests.utils import waiters

LOG = logger.logger


@pytest.fixture(scope="function")
def netchecker_cleanup_actions(request, target_cluster):
    netchecker = NetcheckerManager(target_cluster)
    netchecker_obj_name = netchecker.netchecker_obj_name
    cluster_ns = target_cluster.namespace
    netchecker_object = netchecker.infraconnectivitymonitors.list(namespace=cluster_ns)
    if netchecker_object:
        netchecker_object = netchecker_object[0]
        LOG.info(f"Cleanup existing netchecker {netchecker_object.name} before test")
        netchecker_object.delete()
        waiters.wait(lambda: not netchecker.infraconnectivitymonitors.present(name=netchecker_obj_name,
                                                                              namespace=cluster_ns))
    else:
        LOG.info("No cleanup actions are required. Netchecker object is not found")
    yield
    netchecker_object = netchecker.infraconnectivitymonitors.list(namespace=cluster_ns)
    if netchecker_object:
        netchecker_object = netchecker_object[0]
        test_name = request.node.name
        file_name = f'netchecker-after-{test_name}'
        netchecker_data_file_path = os.path.join(settings.ARTIFACTS_DIR, file_name)
        LOG.info(f"Dump existing netchecker {netchecker_object.name} data to file "
                 f"{netchecker_data_file_path} before deletion")
        with open(netchecker_data_file_path, 'w') as f:
            f.write(yaml.dump(netchecker_object.data))
        LOG.info("Removing netchecker after test")
        netchecker_object.delete()
        waiters.wait(lambda: not netchecker.infraconnectivitymonitors.present(name=netchecker_obj_name,
                                                                              namespace=cluster_ns))
    else:
        LOG.info("Netchecker object not found. Nothing to cleanup")
