def collect_cluster_readiness(func):
    """
    Decorator to store cluster readiness states
    Static field 'readiness' can be called anywhere to receive latest cluster state
    """
    collect_cluster_readiness.readiness = {}

    def wrapped(*args, **kwargs):
        result = func(*args, **kwargs)
        collect_cluster_readiness.readiness = result
        return result

    return wrapped
