from . import file_utils, commons


def get_resource_namespace(path=None):
    resource = file_utils.get_yaml_content(
        file_utils.join(commons.RELEASE_DIR, path))
    return resource['spec']['releases'][0].get(
        'namespace', 'openstack')


class Namespace:

    @property
    def default(self):
        return "default"

    @property
    def osh(self):
        return "osh-system"

    @property
    def metallb(self):
        return "metallb"

    @property
    def ceph(self):
        return "ceph-lcm-mirantis"

    @property
    def rook(self):
        return "rook-ceph"

    @property
    def stacklight(self):
        return "stacklight"

    @property
    def openstack(self):
        return "openstack"

    @property
    def iam(self):
        return "iam"

    @property
    def tf(self):
        return "tf"

    @property
    def kube_system(self):
        return "kube-system"

    @property
    def coredns(self):
        return "coredns"

    @property
    def vbmc(self):
        return "openstack-vbmc"

    @property
    def vault(self):
        try:
            return get_resource_namespace('release/3rd-party/40-vault.yaml')
        except FileNotFoundError:
            return 'openstack'

    @property
    def etcd_vault(self):
        try:
            return get_resource_namespace('release/3rd-party/35-etcd.yaml')
        except FileNotFoundError:
            return 'openstack'

    @property
    def redis(self):
        try:
            return get_resource_namespace('release/80-redis-operator.yaml')
        except FileNotFoundError:
            return 'openstack-redis'


NAMESPACE = Namespace()
