import re
import os

from .namespace import NAMESPACE
from . import file_utils


def is_core_dns(os_manager):
    return os_manager.api.configmaps.list(
        NAMESPACE.kube_system,
        field_selector="metadata.name=coredns")


def get_external_dns_ip(os_manager):
    core_dns_service = os_manager.api.services.get(
        "coredns-coredns", NAMESPACE.coredns)

    dns_service = core_dns_service.read()
    ingress = dns_service.status.load_balancer.ingress
    ext_dns_ip = None
    if ingress:
        ext_dns_ip = ingress[0].ip
    ext_dns_ip = ext_dns_ip or dns_service.spec.cluster_ip
    return ext_dns_ip


def get_local_domain(os_manager):
    domain = "cluster.local"

    if is_core_dns(os_manager):
        corefile = os_manager.api.configmaps.get(
            "coredns", NAMESPACE.kube_system).read().data["Corefile"]
        domain = re.findall("^.*in-addr.arpa.*{", corefile, re.MULTILINE
                            )[0].strip().split(" ")[1]

    return domain


def get_ceph_operator_yaml():
    ceph_yaml = file_utils.get_release("50-ceph-controller.yaml")
    if not os.path.exists(ceph_yaml):
        ceph_yaml = file_utils.get_release("32-ceph-controller.yaml")
    return ceph_yaml
