
from si_tests.utils import utils
from si_tests.deployments.utils import file_utils, commons


@utils.log_method_time()
def generate_ssl_certificates(os_manager, timeout):
    commons.LOG.info("Prepare ssl config")
    certs_path = file_utils.get_context("certs")
    cffsl_binary = utils.get_binary_path("cfssl")
    cfssljson_binary = utils.get_binary_path("cfssljson")

    commons.LOG.info("Generate ssl certificates")
    executor = commons.get_local_executor()
    result = executor.execute(
        f"{cffsl_binary} gencert -ca=ca.crt -ca-key=ca.key api-csr.json |"
        f"{cfssljson_binary} -bare \"api\"",
        cwd=certs_path)

    commons.LOG.info("%s", result.stderr)
    assert result.exit_code == 0, result
