#    Copyright 2022 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations

from si_tests.clients.k8s import base
from si_tests.utils.waiters import wait


class V1NodeWorkloadLock(base.BaseModel):
    pass


class V1NodeWorkloadLockList(base.BaseModelList):
    pass


class NodeWorkloadLock(base.K8sClusterScopedResource):
    resource_type = 'nodeworkloadlock'
    model = V1NodeWorkloadLock

    @property
    def nodename(self):
        return self.data['spec']['nodeName']

    @property
    def controllername(self):
        return self.data['spec']['controllerName']

    @property
    def state(self):
        if self.data['status'] is not None:
            return self.data['status'].get('state')


class NodeWorkloadLockManager(base.K8sBaseManager):
    model = V1NodeWorkloadLockList
    resource_class = NodeWorkloadLock
    resource_group = 'lcm.mirantis.com'
    resource_version = 'v1alpha1'
    resource_plural = 'nodeworkloadlocks'

    def get_node_workload_lock_state(self, name):
        nwl = self.get(name)
        return nwl.state

    def check_nwl_state(self, name, state):
        return self.get_node_workload_lock_state(name) == state

    def get_nwl_by_state(self, state):
        res = []
        for nwl in self.list_all():
            if nwl.state == state:
                res.append(nwl)
        return res

    def check_nwl_by_state_number(self, state, number):
        return len(self.get_nwl_by_state(state)) == number

    def wait_nwl_state(self, nwl_name, state, timeout=120, interval=10):
        wait(
            self.check_nwl_state,
            predicate_args=(nwl_name, state),
            timeout=timeout,
            interval=interval,
        )
