#!/bin/bash
echo "Sourcing $MY_PROJFOLDER/env.sh"
. $MY_PROJFOLDER/env.sh
if [ -z ${TEMPEST_CUSTOM_PUBLIC_NET+x} ]; then
	echo "# WARNING: Public network is empty, please export its name to TEMPEST_CUSTOM_PUBLIC_NET environment variable to use some specific external net in case of several networks. Otherwise random external network will be used."
fi
# mosrc
. $MY_PROJFOLDER/envs/mosrc

# local vars
raw_disk_format=false

function show_help {
    printf "QA verification: Resources creation script\n\t-h, -?\t\tShow this help\n"
    printf "\t-r\t\tTo create the images in RAW disk format instead of the QCOW2\n"
}

OPTIND=1 # Reset in case getopts has been used previously in the shell.
while getopts "rh?"  opt; do
    case "$opt" in
    h|\?)
        show_help
        exit 0
        ;;
    r)  raw_disk_format=true
        printf "# Creating the images in RAW disk format instead of the QCOW2\n"
        ;;
    esac
done

##
echo "### Checking openstack resources"
status=$(kubectl -n qa-space get pod | grep toolset | tr -s " " | cut -d' ' -f3)
if [ ${status} != "Running" ]; then
	echo "# 'toolset' container is not Running"
	exit 1
fi
if [ ! -z $(kubectl exec toolset --stdin -n qa-space -- bash -c "openstack user show cvp.admin -c id -f value") ]; then
        echo "# Resources already created"
	echo " "
	kubectl exec toolset --stdin -n qa-space -- bash -c "cat /artifacts/cmp-check/cvp.manifest"
else
  echo "# Creating openstack resources"
	echo " "
	kubectl exec toolset --stdin -n qa-space -- bash -c "mkdir /artifacts/cmp-check"
	if [ "$raw_disk_format" = true ]; then
    kubectl exec toolset --tty --stdin -n qa-space -- bash -c "cd /artifacts/cmp-check; export CUSTOM_PUBLIC_NET_NAME="${TEMPEST_CUSTOM_PUBLIC_NET:-}"; bash /opt/cmp-check/prepare.sh -r -w \$(pwd)"
	else
   kubectl exec toolset --tty --stdin -n qa-space -- bash -c "cd /artifacts/cmp-check; export CUSTOM_PUBLIC_NET_NAME="${TEMPEST_CUSTOM_PUBLIC_NET:-}"; bash /opt/cmp-check/prepare.sh -w \$(pwd)"
  fi
fi

#
echo " "
echo "# Filling tempest_custom.yaml"
# TODO: set the correct availability_zone in case nova is not used (now nova is default option)
cp -v /opt/res-files/k8s/yamls/tempest_custom.yaml.clean $MY_PROJFOLDER/yamls/tempest_custom.yaml
declare $(kubectl exec toolset --stdin -n qa-space -- bash -c "cat /artifacts/cmp-check/cvp.manifest")
echo "# Getting network details"
netid=$(kubectl exec toolset --stdin -n qa-space -- openstack network show ${TEMPEST_CUSTOM_PUBLIC_NET} -c id -f value)
subnetid=$(kubectl exec toolset --stdin -n qa-space -- openstack subnet list -f value | grep ${netid} | cut -d' ' -f1)
#echo "# image_ref_name -> ${cirros61_name}"
#sed -i "s/image_ref_name/${cirros61_name}/g" $MY_PROJFOLDER/yamls/tempest_custom.yaml
#echo "# image_ref_uuid -> ${cirros61_id}"
#sed -i "s/image_ref_uuid/${cirros61_id}/g" $MY_PROJFOLDER/yamls/tempest_custom.yaml
#echo "# image_ref_alt_uuid -> ${cirros62_id}"
#sed -i "s/image_ref_alt_uuid/${cirros62_id}/g" $MY_PROJFOLDER/yamls/tempest_custom.yaml
echo "# s/public_subnet_uuid/ -> ${subnetid}"
sed -i "s/public_subnet_uuid/${subnetid}/g" $MY_PROJFOLDER/yamls/tempest_custom.yaml
echo "# s/public_net_uuid/ -> ${netid}"
sed -i "s/public_net_uuid/${netid}/g" $MY_PROJFOLDER/yamls/tempest_custom.yaml
echo "# s/public_net_name/ -> ${TEMPEST_CUSTOM_PUBLIC_NET}"
sed -i "s/public_net_name/${TEMPEST_CUSTOM_PUBLIC_NET}/g" $MY_PROJFOLDER/yamls/tempest_custom.yaml
echo "# s/volume_type_name/ -> ${TEMPEST_CUSTOM_VOLUME_TYPE}"
sed -i "s/volume_type_name/${TEMPEST_CUSTOM_VOLUME_TYPE}/g" $MY_PROJFOLDER/yamls/tempest_custom.yaml
echo " "

echo "# Checking Neutron global physnet mtu value"
global_physnet_mtu=""
global_physnet_mtu=$(kubectl get osdpl -A -o wide -o yaml | grep global_physnet_mtu | tail -n1 | cut -d':' -f2 | tr -d ' ')
if [ -n "$global_physnet_mtu" ]; then
    echo "global_physnet_mtu is set to: $global_physnet_mtu"
    echo "" >> $MY_PROJFOLDER/yamls/tempest_custom.yaml
    cat <<EOF >> $MY_PROJFOLDER/yamls/tempest_custom.yaml
neutron_plugin_options:
    max_mtu: $global_physnet_mtu
EOF
fi

echo "# Updating SPT global_config.yaml"
cp -v /opt/res-files/k8s/yamls/spt_global_config.yaml.clean $MY_PROJFOLDER/yamls/global_config.yaml
echo "# image_ref_name -> ${ubuntu20_name}"
sed -i "s/image_ref_name/${ubuntu20_name}/g" $MY_PROJFOLDER/yamls/global_config.yaml
echo "# s/public-network-name/ -> ${TEMPEST_CUSTOM_PUBLIC_NET}"
sed -i "s/public-network-name/${TEMPEST_CUSTOM_PUBLIC_NET}/g" $MY_PROJFOLDER/yamls/global_config.yaml
#

echo "# Copying files"
kubectl exec toolset --tty --stdin -n qa-space -- bash -c "cp /artifacts/cmp-check/cvp.manifest /opt/cmp-check/cvp.manifest"
kubectl exec toolset --tty --stdin -n qa-space -- bash -c "cp /artifacts/cmp-check/cvprc /opt/cmp-check/cvprc"
kubectl exec toolset --tty --stdin -n qa-space -- bash -c "cp /artifacts/cmp-check/cvprc /opt/cvprc"
kubectl exec toolset --tty --stdin -n qa-space -- bash -c "cp /artifacts/cmp-check/cvp_testkey /opt/cmp-check/cvp_testkey"

echo "# Done!"
