import pytest
from kubernetes.client.rest import ApiException
from si_tests import logger

LOG = logger.logger


def test_admission_controller(os_manager):
    LOG.info("Get osdpl object")
    osdpl = os_manager.get_osdpl_deployment()
    current_version = osdpl.read().spec["openstack_version"]

    openstack_versions = [None, "queens", "rocky", "stein",
                          "train", "ussuri", "master"]

    current_idx = openstack_versions.index(current_version)

    upper_versions = openstack_versions[current_idx + 2:]

    lower_version = openstack_versions[current_idx - 1]

    if lower_version:
        LOG.info("Try downgrade from {} to {}".format(
            current_version, lower_version))
        with pytest.raises(ApiException) as exc_info:
            osdpl.patch({"spec": {"openstack_version": lower_version}})
        assert exc_info.value.status == 400
        assert exc_info.value.reason == 'Bad Request'
    else:
        LOG.info("No version to downgrade from {}".format(current_version))

    for release in upper_versions:
        LOG.info("Try to upgrade from {} to {}".format(
            current_version, release))
        with pytest.raises(ApiException) as exc_info:
            osdpl.patch({"spec": {"openstack_version": release}})
        assert exc_info.value.status == 400
        assert exc_info.value.reason == 'Bad Request'

    LOG.info("Admission controller successfully rejected downgrade, "
             "skip-level and master upgrade")
