from si_tests import logger
from si_tests.lcm.openstack_lcm.policies import Policy
from si_tests.utils.utils import verify


LOG = logger.logger


def test_crud_operations_secret_policy(openstack_client_manager,
                                       policy_user):
    """Test CRUD operations  for secret policy
       https://mirantis.testrail.com/index.php?/cases/view/4963685

       Parameters required for test execution:
         - KUBECONFIG

       Setup environment:
       Create user with role member
    """
    user_name, password = policy_user
    http_exception = "Forbidden"
    os_service = 'barbican'
    os_pod = 'barbican-api'
    policy = Policy(os_service, os_pod)

    try:
        get_policy_file_before_update = \
            ['/bin/sh', '-c',
             r' grep -rin "secrets:get"'
             ' /etc/barbican/policy.d/02-custom.yaml']
        policy.check_policy_absent_before_update(
            get_policy_file_before_update)

        LOG.info("Step 1:Check that policy is absent,"
                 " secret list is shown only by admin")
        step = 1

        secret_list = openstack_client_manager.secret.list(
            [], combined_output=True)
        verify(http_exception not in secret_list["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Secret list is possible by admin")

        error_output = openstack_client_manager.secret.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Secret list is not possible by user")

        LOG.info("Step 2: Add to osdpl new rule")
        step = 2
        policy_add_role = {'secrets:get': '!'}

        policy.update_policy_osdpl(policy_add_role, step)

        LOG.info("Step 3: Check on barbican api pod policies was added")
        check_policy_file = ['/bin/sh', '-c',
                             ' cat /etc/barbican/policy.d/02-custom.yaml']
        policy.wait_policy_updated_on_pod(check_policy_file, policy_add_role,
                                          step)

        LOG.info("Step 4: Check that policy added. Secret"
                 "list are not possible by admin and member user")
        step = 4

        error_output = openstack_client_manager.secret.list(
            [], combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Secret list is not possible by admin")

        error_output = openstack_client_manager.secret.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Secret is not possible by user")

        LOG.info("Step 5: Update policies. Check that policy added "
                 "on barbican api pod ")
        step = 5
        policy_update_role = {'secrets:get': 'rule:admin'}

        policy.update_policy_osdpl(policy_update_role, step)
        policy.wait_policy_updated_on_pod(check_policy_file,
                                          policy_update_role, step)

        LOG.info("Step 6: Check that policy added and"
                 " secret list is shown only by admin")
        step = 6

        secret_list = openstack_client_manager.secret.list(
            [], combined_output=True)
        verify(http_exception not in secret_list["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Secret list is not possible by admin")

        error_output = openstack_client_manager.secret.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Secret list is not possible by user")

        LOG.info("Step 7: Update policies. Check that policy added "
                 "on barbican api pod ")
        step = 7
        policy_update_role = {'secrets:get': '@'}

        policy.update_policy_osdpl(policy_update_role, step)
        policy.wait_policy_updated_on_pod(check_policy_file,
                                          policy_update_role, step)

        LOG.info("Step 8: Check that policy added and secret list "
                 "is shown by admin and member user")
        step = 8

        secret_list = openstack_client_manager.secret.list(
            [], combined_output=True)
        verify(http_exception not in secret_list["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Secret list is possible by admin")

        secret_list = openstack_client_manager.secret.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception not in secret_list["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Secret is not possible by user")

    finally:
        LOG.info("Step 9: Delete Policy. Check that policy was deleted and"
                 " result the same in first step ")
        step = 9
        policy_not_role = None
        policy.update_policy_osdpl(policy_not_role, step)

        policy.wait_policy_updated_on_pod(check_policy_file, {},
                                          step)

        secret_list = openstack_client_manager.secret.list(
            [], combined_output=True)
        verify(http_exception not in secret_list["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Secret list is possible by admin")

        error_output = openstack_client_manager.secret.list(
            [f"--os-username={user_name}", f"--os-password={password}"],
            combined_output=True)
        verify(http_exception in error_output["stderr"],
               f"[Step {step}]: Policy is not required to test",
               f"[Step {step}]: Policy is absent. "
               "Secret list is not possible by user")
