#    Copyright 2025 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from si_tests import logger

LOG = logger.logger


class RemoteShellManager(object):
    """Remote Shell Manager manager for day2modules"""

    @staticmethod
    def get_linux_hard_limit(machine):
        """Get linux hard limit on dict

        """
        cmd_results = {}
        # Get linux hard limits for root and mcc-user
        nproc_cmd = "bash -c 'ulimit -Hu'"
        nofile_cmd = "bash -c 'ulimit -Hn'"
        LOG.info(f"Check commands {nproc_cmd} and {nofile_cmd} on machine: {machine.name}")
        cmd_results.update({
            'mcc-user': {
                'nproc': (int(machine.exec_pod_cmd(f'sudo -u mcc-user {nproc_cmd}')['logs'].split()[0])),
                'nofile': (int(machine.exec_pod_cmd(f'sudo -u mcc-user {nofile_cmd}')['logs'].split()[0]))
            },
            'root': {
                'nproc': (int(machine.exec_pod_cmd(f'sudo -u root {nproc_cmd}')['logs'])),
                'nofile': (int(machine.exec_pod_cmd(f'sudo -u root {nofile_cmd}')['logs']))
            }})
        if cmd_results:
            LOG.info(f'Return linux hard limits: {cmd_results}')
            return cmd_results
        LOG.warning(f"Error get hard limits on machine {machine.name}")
        return {}
